/**
 * 
 */
package gov.va.med.mhv.admin.converter;

import gov.va.med.mhv.admin.dto.ActivityDTO;
import gov.va.med.mhv.admin.model.Activity;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

/**
 * @author DNS
 *
 */
@Component
public class ActivityListConverter implements Converter<List<Activity>, List<ActivityDTO>> {

	@Autowired
	private ActivityDTOConverter activityConverter;
	
	@Override
	public List<ActivityDTO> convert(List<Activity> source) {
		
		List<ActivityDTO> destination = new ArrayList<ActivityDTO>();
		for(Activity a : source) {
			destination.add(this.activityConverter.convert(a));
		}
		return destination;
	}
}
